/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_10;

import djbuch.kapitel_06.GC;
import djbuch.kapitel_19.DJLog;
import lotus.domino.*;

/**
 * @author Thomas Ekert
 *
 */
public class DJLoopDemo extends NotesThread {

	private static final String PASSWORD = "geheim";
	private static final String HOST = "www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = "Thomas Ekert/DJBUCH";	//null fr lokale Session

	public static void main(String[] args) {
		DJLoopDemo loopDemo = new DJLoopDemo();
		loopDemo.start();
	}
	public void runNotes() {
		Database db = null;
		Session session = null;
		try {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
			db = session.getDatabase("", "djbuch/djbuch.nsf");
			dumpView (db, "V_Dokumente_k6", null);
		} catch (NotesException e) {
			DJLog.writeException (e);
		} finally {
			GC.recycle(db);
			GC.recycle(session);
		}
	}
	
	private static final int dumpView (Database db, String viewName, String query)
			throws NotesException {
		View view = null; 
		try {
			view = db.getView(viewName);
			if (view==null) { return -1; }
			if (query!=null) { view.FTSearch(query); }
			view = db.getView ("V_Dokumente_k6");
			DJLoopCommandDumpDoc command = new DJLoopCommandDumpDoc (view);
			DJLoopExecutor exec = new DJLoopExecutor (command);
			exec.doLoop();
			return command.getSize();
		} finally {
			GC.recycle(view);
		}
	}
}
